﻿using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

public class SpeedDisplay : MonoBehaviour
{
    [SerializeField]
    private GameObject car;

    [SerializeField]
    private float speed;

    [SerializeField]
    private TMP_Text speedText;

    private Vector3 lastPosition;
    private float elapsed;

    // Start is called before the first frame update
    void Start()
    {
        speed = 0;
        lastPosition = car.transform.position;
        elapsed = 0;

        StartCoroutine(CalcVelocity());
    }

    // Update is called once per frame
    void Update()
    {

    }

    IEnumerator CalcVelocity()
    {
        while (Application.isPlaying)
        {
            lastPosition = car.transform.position;
            yield return new WaitForFixedUpdate();
            speed = Mathf.RoundToInt(Vector3.Distance(car.transform.position, lastPosition) / Time.fixedDeltaTime);
            elapsed += Time.deltaTime;
            if (elapsed >= 0.2f)
            {
                elapsed = elapsed % 0.2f;
                speedText.text = speed.ToString() + " km/h";
            }
        }
    }
}
